#ifndef _Command_CPP
#define _Command_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <SQL.H>
#include <SqlExt.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "../../SharedSource/LZARICode.H"

#include "../../SharedClasses/CRC32/CRC.H"

#include "../../SharedClasses/SQLClass/cSQL.H"
#include "../../SharedClasses/SQLClass/cRecordSet.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../../SharedSource/NSWFL.H"
#include "Init.H"
#include "Entry.H"
#include "Routines.H"
#include "Command.H"
#include "SQLImport.H"
#include "Console.H"
#include "NewDB.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ReceiveFileData(CSockSrvr *pSockSrvr, int iClient, char *sFileName);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	int ProcessCommand(CSockSrvr *pSockSrvr, int iClient, char *sRecvBuf, int iRecvBufSz);

	Processes a command from the peer.

	Possible return Values:
		CMD_OK    The command was a success, all is well.
		CMD_DONE  The command was a success, close the connection.
		CMD_ERROR The command failed due to an error.
*/
int ProcessCommand(CSockSrvr *pSockSrvr, int iClient, char *sCmdBuf, int iCmdBufSz)
{
    char sCmdData[IDEAL_RECV_SIZE + 1];

	int iSendBufSz = 0;
	int iCmdDataSz = 0;
	int iCmdFlagLength = 0;

    if((iCmdFlagLength = CmdCmp(sCmdBuf, "::SendingDBCreationSQL")))
    {
        sprintf(CCI[iClient].sFileName, "%s\\%s\\DBCreation.wpd", gsImportTempDir, CCI[iClient].sCompanyName);
        CreateFolderStructure(CCI[iClient].sFileName);

		if(ReceiveFileData(pSockSrvr, iClient, CCI[iClient].sFileName))
		{
			if(CreateNewDBFromDBCreationScript(&CCI[iClient].cCustSQL, pSockSrvr, iClient, CCI[iClient].sFileName))
			{
				pSockSrvr->SetNextSendData(iClient, "::BeginReplication->All");
				return CMD_OK;
			}
		}

		return CMD_ERROR;
	}
	else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::Complete")))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "The process has been completed successfully.");

		if(CCI[iClient].bRequestInit)
		{
			sprintf(sCmdData, "UPDATE [%s].[%s].[Companys]"
				" SET Init = 0"
				" WHERE CompName = '%s'",
				gsSQLIndexDatabase, gsDefaultDBO, CCI[iClient].sCompanyName);

			CCI[iClient].cIndexSQL.ExecuteNonQuery(sCmdData);
		}

		return CMD_DONE;
	}
	else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::Msg->")))
    {
		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);
		WriteLog(pSockSrvr->icClientID[iClient], sCmdData);
		return CMD_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::SendingFileData->")))
    {
		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

        sprintf(CCI[iClient].sFileName, "%s\\%s\\%s.wpd", gsImportTempDir, CCI[iClient].sCompanyName, sCmdData);
        CreateFolderStructure(CCI[iClient].sFileName);

		ReceiveFileData(pSockSrvr, iClient, CCI[iClient].sFileName);

		bool bCheckExistance = true;

		if(CCI[iClient].bRequestInit)
		{
			bCheckExistance = false;
		}

		if(ImportSQLResults(pSockSrvr, iClient, bCheckExistance, CCI[iClient].sFileName))
        {
			pSockSrvr->SetNextSendData(iClient, "::LastImportSuccess");
			return CMD_OK;
        }
        else{
            // FIXME: Should we return CMD_OK or CMD_ERROR?
			pSockSrvr->SetNextSendData(iClient, "::LastImportFailed");
			return CMD_OK;
        }

		return CMD_OK;
	}

	giWarningCount++;
	WriteLog(pSockSrvr->icClientID[iClient], "Received unknown command.");

	sCmdBuf[1024] = '\0';
	WriteLog(pSockSrvr->icClientID[iClient], sCmdBuf);
	return CMD_ERROR;	
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ReceiveFileData(CSockSrvr *pSockSrvr, int iClient, char *sFileName)
{
    FILE *hTargetHandle = NULL;

    char sText[1024];
    //char sCRC[100];
	char sFullFile[MAX_PATH];
	char sRecvBuf[IDEAL_RECV_SIZE + 1];
    int iRecvBufSz = 0;

	//DWORD dwDataCRC = 0xffffffff;

	WriteLog(pSockSrvr->icClientID[iClient], "Begining file transfer.");

	if(gbUseCompression)
	{
		sprintf(sFullFile, "%s.lza", sFileName);
	}
	else{
		strcpy(sFullFile, sFileName);
	}

	if( (hTargetHandle = fopen(sFullFile, "wb")) == NULL)
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Failed to open export file for binary write.");
        return false;
    }

	if(gbDebugMode)
	{
		sprintf(sText, "File opened successfully. [%s]", sFullFile);
		WriteLog(pSockSrvr->icClientID[iClient], sText);
	}

	while(pSockSrvr->bcConnected[iClient] && !pSockSrvr->bcDisconnect[iClient])
    {
        if(pSockSrvr->GetClientData(iClient, sRecvBuf, &iRecvBufSz))
        {
			if(iRecvBufSz == 5)
			{
				sRecvBuf[iRecvBufSz] = '\0';
				if(strcmp(sRecvBuf, "::EOF") == 0)
				{
/*
					//Wait on the data CRC.
					if(pSockSrvr->GetNextClientData(iClient, sRecvBuf, &iRecvBufSz))
					{
						if(iRecvBufSz > 25)
						{
							//This helps prevent aganst buffer overflows.
							sRecvBuf[25] = '\0';	
						}
						else sRecvBuf[iRecvBufSz] = '\0';

						sprintf(sCRC, "%X", dwDataCRC);
						if(strcmpi(sRecvBuf, sCRC) != 0)
						{
							sprintf(sText, "Invalid CRC. Client: %s, Server: %s", sRecvBuf, sCRC);
							WriteLog(pSockSrvr->icClientID[iClient], sText);
							return false;
						}

						if(gbDebugMode)
						{
							sprintf(sText, "CRC Values OK! Client: %s, Server: %s", sRecvBuf, sCRC);
							WriteLog(pSockSrvr->icClientID[iClient], sText);
						}
						break; // All is well.
					}
					else{
						fclose(hTargetHandle);
						return false;
					}
					*/

					break; // All is well.
				}
			}

			CCI[iClient].cNASCCL.Decode(sRecvBuf, sRecvBuf, iRecvBufSz);
            //dwDataCRC = PartialCRC(dwDataCRC, sRecvBuf, iRecvBufSz);
			fwrite(sRecvBuf, sizeof(char), iRecvBufSz, hTargetHandle);
		}
		else Sleep(1);
	}

	fclose(hTargetHandle);

	if(gbUseCompression)
	{
		float dwBeforeSz = 0;
		float dwAfterSz = 0;

		sprintf(sFullFile, "%s.lza", sFileName);

		dwBeforeSz = (float) Get_FileSize(sFullFile);

		sprintf(sRecvBuf, "Decompressing file. (%.2f KB)", dwBeforeSz / 1024);
		WriteLog(pSockSrvr->icClientID[iClient], sRecvBuf);
		DecompressFile(sFullFile, sFileName);

		dwAfterSz = (float) Get_FileSize(sFileName);

		sprintf(sRecvBuf, "File size increased from %.2f KB to %.2f KB. (%.2f %% Decompression).",
			dwBeforeSz / 1024, dwAfterSz / 1024, (100 - ((dwBeforeSz / dwAfterSz) * 100)));
		WriteLog(pSockSrvr->icClientID[iClient], sRecvBuf);

		if(gbDeleteCompressedFiles)
		{
			DeleteFile(sFullFile);
		}
	}

	if(pSockSrvr->bcConnected[iClient] && !pSockSrvr->bcDisconnect[iClient])
	{
		return true;
	}
	else return false;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
